local TABAS_BodyGrime = {}

local TABAS_Utils = require("TABAS_Utils")

local FirstPhase = 30
local SecondPhase = 55
local ThirdPhase = 80

function TABAS_BodyGrime.updateBodyGrime(character)
    local bloodThreshold = SandboxVars.TakeABathAndShower.BloodToGrimeThreshold
    local dirtThreshold = SandboxVars.TakeABathAndShower.DirtToGrimeThreshold
    local grimeIncreaseBase = SandboxVars.TakeABathAndShower.BodyGrimeIncreasedBase -- default 0.25
    local bloodAndDirtMultiplier = SandboxVars.TakeABathAndShower.BloodAndDirtMultiplier
    local grimeDiscomfort = SandboxVars.TakeABathAndShower.GrimeDiscomfort

    local modData = character:getModData()
    local bodyGrime = modData.BodyGrime
    local bodyBlood, bodyDirt = TABAS_Utils.getBodyBloodAndDirt(character)
    if bodyBlood < bloodThreshold then
        bodyBlood = 0
    else
        bodyBlood = bodyBlood * 0.01 * bloodAndDirtMultiplier
    end
    if bodyDirt < dirtThreshold then
        bodyDirt = 0
    else
        bodyDirt = bodyDirt * 0.01 * bloodAndDirtMultiplier
    end
    local Increased =  grimeIncreaseBase + bodyBlood + bodyDirt

    modData.BodyGrime = math.min(bodyGrime + Increased, 100.0)

    if isDebugEnabled() then
        print("BodyGrime updated:  Increased: (base = "..grimeIncreaseBase..", blood = "..bodyBlood..", dirt = "..bodyDirt..") total = "..Increased..", Current: "..character:getModData().BodyGrime)
        -- print(string.format("BodyGrime updated:  Increased: (base = %d, blood = %d, dirt = %d) total = %d, Current: %d", .. grimeIncreaseBase .. Increased .. ", Current: " .. tostring(character:getModData().BodyGrime))
    end

    if grimeDiscomfort then
        if bodyGrime >= ThirdPhase then
            TABAS_Utils.addFakeWornItem(character, "TABAS.BodyGrime3")
        elseif bodyGrime >= SecondPhase then
            TABAS_Utils.addFakeWornItem(character, "TABAS.BodyGrime2")
        elseif bodyGrime >= FirstPhase then
            TABAS_Utils.addFakeWornItem(character, "TABAS.BodyGrime1")
        else
            TABAS_Utils.removeFakeWornItem(character, "TABAS.BodyGrime1")
        end
    end
end

function TABAS_BodyGrime.createDebugMenu(player, context, worldObjects, test)
    if not isDebugEnabled() then return end
    local mainMenu = context:addOption("Dev: Body Grime Info")
    local subMenu = ISContextMenu:getNew(context)
    context:addSubMenu(mainMenu, subMenu)
    TABAS_BodyGrime.GrimeInfoMenu(player, subMenu)
end

function TABAS_BodyGrime.GrimeInfoMenu(player, context)
    local playerObj = getSpecificPlayer(player)
    local currentGrime = round(playerObj:getModData().BodyGrime, 4)
    -- Displays current Body Grime
    context:addOption("Current Grime: " .. tostring(currentGrime))
    -- Body Grime to value
    context:addOption("Body Grime to 0", playerObj, TABAS_BodyGrime.forceValue, 0)
    context:addOption("Body Grime to 30", playerObj, TABAS_BodyGrime.forceValue, 30)
    context:addOption("Body Grime to 50", playerObj, TABAS_BodyGrime.forceValue, 50)
    context:addOption("Body Grime to 100", playerObj, TABAS_BodyGrime.forceValue, 100)
end

function TABAS_BodyGrime.forceValue(playerObj, value)
    playerObj:getModData().BodyGrime = value
    TABAS_BodyGrime.updateBodyGrime(playerObj)
end

local function everyHoursUpdate()
    if not SandboxVars.TakeABathAndShower.EnableBodyGrime then return end
    for i=0, getNumActivePlayers()-1 do
        local character = getSpecificPlayer(i)
        if character then
            TABAS_BodyGrime.updateBodyGrime(character)
        end
    end
end

local function onCreatePlayer(playerNum, player)
    local playerObj = getSpecificPlayer(playerNum)
    if playerObj:getModData().BodyGrime == nil then
        playerObj:getModData().BodyGrime = 0
    end
end

local function onClearGrime()
    if SandboxVars.TakeABathAndShower.EnableBodyGrime then return end
    for i=0, getNumActivePlayers()-1 do
        local character = getSpecificPlayer(i)
        if character then
            character:getModData().BodyGrime = 0
            TABAS_Utils.removeFakeWornItem(character, "TABAS.BodyGrime1")
            TABAS_Utils.removeFakeWornItem(character, "TABAS.BodyGrime2")
            TABAS_Utils.removeFakeWornItem(character, "TABAS.BodyGrime3")
        end
    end
end

Events.EveryHours.Add(everyHoursUpdate)
Events.OnCreatePlayer.Add(onCreatePlayer)
Events.OnFillWorldObjectContextMenu.Add(TABAS_BodyGrime.createDebugMenu)
Events.OnGameStart.Add(onClearGrime)

return TABAS_BodyGrime